package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;

/**
 * A special {@link StateSpaceNode} that represents the root of the search
 * space and holds a pointer to the problem object and the search budget.
 * 
 * @author Stephen G. Ware
 */
public interface StateSpaceRoot {

	/**
	 * Returns the state space problem being solved.
	 * 
	 * @return the problem
	 */
	public StateSpaceProblem getProblem();
	
	/**
	 * The search budget for solving this problem.
	 * 
	 * @return the budget
	 */
	public SearchBudget getBudget();
}
