package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.planning.Planner;
import edu.uky.ai.planning.Problem;

/**
 * A planner which searches the space of states for the solution to a given
 * problem.
 * 
 * @author Stephen G. Ware
 */
public abstract class StateSpacePlanner<S extends StateSpaceSearch> extends Planner<S> {

	/**
	 * Constructs a new state space planner with a given name.
	 * 
	 * @param name the name of the planner
	 */
	public StateSpacePlanner(String name) {
		super(name);
	}
	
	@Override
	protected S makeSearch(Problem problem, SearchBudget budget) {
		return makeStateSpaceSearch(new StateSpaceProblem(problem), budget);
	}

	/**
	 * Given some state space problem to be solved, this method constructs the
	 * appropriate kind of {@link StateSpaceSearch} to solve it based on this
	 * planner.
	 * 
	 * @param problem the state space problem to be solved
	 * @param budget the search budget in which to solve it
	 * @return a state space search object for solving this problem
	 */
	protected abstract S makeStateSpaceSearch(StateSpaceProblem problem, SearchBudget budget);
}
