package edu.uky.ai.planning.ss;

import edu.uky.ai.logic.Proposition;
import edu.uky.ai.logic.State;

/**
 * A state space heuristic estimates the distance (as number of steps) between
 * a given state and a given goal proposition.
 * 
 * @author Stephen G. Ware
 */
public interface StateSpaceHeuristic {

	/**
	 * For a given problem, estimate the distance between the given state and
	 * the given goal proposition in number of steps.
	 * 
	 * @param problem the problem being solved
	 * @param state any state
	 * @param goal any goal proposition
	 * @return an estimate of the number of steps needed to achieve the goal
	 * from the state
	 */
	public double evaluate(StateSpaceProblem problem, State state, Proposition goal);
}
