package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;

/**
 * A special {@link ForwardNode} that represents the root of the forward search
 * space and holds a pointer to the problem object and the search budget.
 * 
 * @author Stephen G. Ware
 */
public class ForwardRoot extends ForwardNode implements StateSpaceRoot {

	/** The planning problem being solved */
	public final StateSpaceProblem problem;
	
	/** The search budget */
	public final SearchBudget budget;
	
	/** The total number of nodes visited */
	int visited = 0;
	
	/** The total number of nodes generated */
	int generated = 1;
	
	/**
	 * Constructs a new root node.
	 * 
	 * @param problem the state space problem being solved
	 * @param budget the search budget
	 * root
	 */
	ForwardRoot(StateSpaceProblem problem, SearchBudget budget) {
		super(problem.initial);
		this.problem = problem;
		this.budget = budget;
	}

	@Override
	public StateSpaceProblem getProblem() {
		return problem;
	}

	@Override
	public SearchBudget getBudget() {
		return budget;
	}
}
