package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.planning.Problem;

/**
 * A planner which searches forward through space of states for the solution to
 * a given problem.
 * 
 * @author Stephen G. Ware
 */
public abstract class ForwardPlanner extends StateSpacePlanner<ForwardSearch> {

	/**
	 * Constructs a new forward state space planner with a given name.
	 * 
	 * @param name the name of the planner
	 */
	public ForwardPlanner(String name) {
		super(name);
	}

	@Override
	protected ForwardSearch makeSearch(Problem problem, SearchBudget budget) {
		return makeStateSpaceSearch(new StateSpaceProblem(problem), budget);
	}
	
	@Override
	protected ForwardSearch makeStateSpaceSearch(StateSpaceProblem problem, SearchBudget budget) {
		return makeForwardSearch(problem, budget);
	}
	
	/**
	 * Given some state space problem to be solved, this method constructs the
	 * appropriate kind of {@link ForwardSearch} to solve it based on this
	 * planner.
	 * 
	 * @param problem the state space problem to be solved
	 * @param budget the search budget in which to solve it
	 * @return a forward state space search object for solving this problem
	 */
	protected abstract ForwardSearch makeForwardSearch(StateSpaceProblem problem, SearchBudget budget);
}
