package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;

/**
 * Represents a backward search through the space of states, starting at the
 * problem goal and ending in the initial state. In the graph defined by this
 * search, {@link BackwardNode nodes} are goals to be achieved and edges are
 * {@link edu.uky.ai.planning.Step steps}.
 * 
 * @author Stephen G. Ware
 */
public abstract class BackwardSearch extends StateSpaceSearch {

	/** The root node of the search space (i.e. a plan with 0 steps) */
	public final BackwardRoot root;
	
	/**
	 * Creates a backward state space search for a given problem.
	 * 
	 * @param problem the problem whose state space will be searched
	 * @param budget the maximum number of states that may be searched and the
	 * maximum number of milliseconds the search may take
	 */
	public BackwardSearch(StateSpaceProblem problem, SearchBudget budget) {
		super(problem, budget, new BackwardRoot(problem, budget));
		this.root = (BackwardRoot) super.root;
	}

	@Override
	public int countVisited() {
		return root.visited;
	}

	@Override
	public int countGenerated() {
		return root.generated;
	}
}
