package edu.uky.ai.planning.ps;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.planning.Problem;
import edu.uky.ai.planning.Search;

/**
 * A subclass of {@link edu.uky.ai.planning.Search Search} which represents
 * plan-space search (i.e. search through a tree of
 * {@link edu.uky.ai.planning.ps.PlanSpaceNode plan space nodes}).
 * 
 * @author Stephen G. Ware
 */
public abstract class PlanSpaceSearch extends Search {

	/** The root of the search space */
	public final PlanSpaceRoot root;
	
	/**
	 * Constructs a new plan space search object.
	 * 
	 * @param problem the problem to be solved
	 * @param budget the search budget
	 */
	public PlanSpaceSearch(Problem problem, SearchBudget budget) {
		super(problem, budget);
		root = new PlanSpaceRoot(problem, budget);
	}

	@Override
	public int countVisited() {
		return root.visited;
	}

	@Override
	public int countGenerated() {
		return root.generated;
	}
}
