package edu.uky.ai.planning.ps;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.planning.Planner;
import edu.uky.ai.planning.Problem;

/**
 * A subclass of {@link edu.uky.ai.planning.Planner Planner} which uses
 * plan-space search for find solutions.
 * 
 * @author Stephen G. Ware
 */
public abstract class PlanSpacePlanner extends Planner<PlanSpaceSearch> {

	/**
	 * Constructs a new plan-space planner with the given name.
	 * 
	 * @param name the planner's name
	 */
	public PlanSpacePlanner(String name) {
		super(name);
	}

	@Override
	protected abstract PlanSpaceSearch makeSearch(Problem problem, SearchBudget budget);
}
