package edu.uky.ai.planning.ps;

import edu.uky.ai.logic.Substitution;

/**
 * This interface is implemented by any object which is affected by the
 * bindings of a least-commitment plan.  It provides a
 * {@link #toString(Substitution)} method which returns a string in which
 * all variables with known values have been replaced by their values.
 * 
 * @author Stephen G. Ware
 */
public interface Partial {
	
	/**
	 * Returns a string representation of this object in which all variables
	 * which have values in the given substitution have been replaced with
	 * those values.
	 * 
	 * @param substitution a substitution which may contain values for variabels used in this object
	 * @return a string
	 */
	public abstract String toString(Substitution substitution);
}
