package edu.uky.ai.planning.ps;

import edu.uky.ai.logic.ListBindings;
import edu.uky.ai.logic.Literal;
import edu.uky.ai.logic.Substitution;

/**
 * A causal link describes how the effect of an earlier step (the tail)
 * satisfied the precondition of a later step (the head).
 * 
 * @author Stephen G. Ware
 */
public class CausalLink implements Partial {

	/** The earlier step */
	public final PartialStep tail;
	
	/** The fact that is an effect of the tail and a precondition of the head */
	public final Literal label;
	
	/** The later step */
	public final PartialStep head;
	
	/**
	 * Constructs a new causal link with the given tail, label, and head.
	 * 
	 * @param tail the earlier step
	 * @param label the fact established
	 * @param head the later step
	 */
	public CausalLink(PartialStep tail, Literal label, PartialStep head) {
		this.tail = tail;
		this.label = label;
		this.head = head;
	}
	
	@Override
	public boolean equals(Object other) {
		if(other instanceof CausalLink) {
			CausalLink otherCL = (CausalLink) other;
			return tail.equals(otherCL.tail) && label.equals(otherCL.label) && head.equals(otherCL.head);
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return tail.hashCode() + label.hashCode() + head.hashCode();
	}
	
	@Override
	public String toString() {
		return toString(ListBindings.EMPTY);
	}

	@Override
	public String toString(Substitution substitution) {
		return tail.toString(substitution) + " -" + label.substitute(substitution) + "-> " + head.toString(substitution);
	}
}
