package edu.uky.ai.planning.pg;

import java.util.Iterator;

/**
 * An iterator which filters a set of nodes by level.  Nodes will only be
 * returned by this iterator if they exist at the given level.
 * 
 * @author Stephen G. Ware
 * @param <N> The kind of node over which this iterator iterates
 */
class NodeIterator<N extends Node> implements Iterator<N> {

	/** The level to filter by */
	private final int level;
	
	/** The collection of nodes to filter */
	private final Iterator<N> nodes;
	
	/** The next node to return, or null if the iterator is finished */
	private N next;
	
	/**
	 * Constructs a new node iterator that filters a given set of nodes by
	 * level.
	 * 
	 * @param level the level to filter by
	 * @param nodes the nodes to filter
	 */
	protected NodeIterator(int level, Iterable<N> nodes) {
		this.level = level;
		this.nodes = nodes.iterator();
		advance();
	}
	
	/**
	 * Moves to the next node which should be returned.
	 */
	private final void advance() {
		while(nodes.hasNext()) {
			next = nodes.next();
			if(next.getLevel() != -1 && next.getLevel() <= level)
				return;
		}
		next = null;
	}
	
	@Override
	public boolean hasNext() {
		return next != null;
	}

	@Override
	public N next() {
		N node = next;
		advance();
		return node;
	}
}