package edu.uky.ai.planning;

import edu.uky.ai.logic.Proposition;

/**
 * A step is a single ground action in a plan which changes the world's state.
 * 
 * @author Stephen G. Ware
 */
public class Step implements Comparable<Step> {

	/** The name of the step */
	public final String name;
	
	/** What must be true before the step can be taken */
	public final Proposition precondition;
	
	/** What becomes true after the step has been taken */
	public final Proposition effect;
	
	/**
	 * Constructs a new step.
	 * 
	 * @param name the name of the step
	 * @param precondition the precondition (must be ground)
	 * @param effect the effect (must be ground)
	 * @throws IllegalArgumentException if either the precodition or effect are not ground
	 */
	public Step(String name, Proposition precondition, Proposition effect) {
		if(!precondition.isGround())
			throw new IllegalArgumentException("Precondition not ground");
		if(!effect.isGround())
			throw new IllegalArgumentException("Effect not ground");
		this.name = name;
		this.precondition = precondition;
		this.effect = effect;
	}
	
	@Override
	public String toString() {
		return name;
	}
	
	@Override
	public int compareTo(Step other) {
		return name.compareTo(other.name);
	}
	
	/*
	public void execute(MutableState state) {
		if(!precondition.isTrue(state))
			throw new IllegalStateException("Cannot take step " + this + " because the precondition is not satisfied.");
		else
			effect.makeTrue(state);
	}
	*/
}
