package edu.uky.ai.logic;

import java.util.HashSet;

/**
 * A variable represents a placeholder for a {@link Term}.
 * 
 * @author Stephen G. Ware
 */
public class Variable extends Term {
	
	/** The next ID number to assign to a unique variable */
	private static int nextID = 0;
	
	/** A set that tracks the names of all variables */
	private static HashSet<String> names = new HashSet<>();

	/**
	 * Constructs a new variable with the given type and name.
	 * 
	 * @param type the type of the variable
	 * @param name the name of the variable
	 */
	public Variable(String type, String name) {
		super(type, name);
		names.add(name);
	}
	
	@Override
	public String toString() {
		return "?" + name;
	}

	@Override
	public boolean isGround() {
		return false;
	}
	
	/**
	 * Returns a new variable object with the same type and a name which is
	 * similar to this variable's name but guaranteed to be unique (i.e. no
	 * other variable has the same name).
	 * 
	 * @return a uniquely named variable of the same type
	 */
	public Variable makeUnique() {
		String name;
		do {
			name = this.name + "-" + nextID++;
		} while(names.contains(name));
		return new Variable(type, name);
	}
}
