package edu.uky.ai.logic;

/**
 * A substitution defines that certain formulas should be replaced by other
 * formulas.
 * 
 * @author Stephen G. Ware
 */
@FunctionalInterface
public interface Substitution {

	/**
	 * Defines what a given formula should be replaced with.
	 * 
	 * @param original the formula which may be replaced
	 * @return the replacement formula, or the original formula if no
	 * replacement is defined
	 */
	public Formula get(Formula original);
}
