package edu.uky.ai;

/**
 * Indicates that an algorithm has taken more than the allowed amount of time.
 * 
 * @author Stephen G. Ware
 */
public class TimeBudgetExceededException extends SearchBudgetExceededException {
	
	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a new exception with a given message.
	 * 
	 * @param message the message explaining what caused the exception
	 */
	TimeBudgetExceededException(String message) {
		super(message);
	}
	
	/**
	 * Constructs a new exception with a default message.
	 */
	TimeBudgetExceededException() {
		this("Search time exceeded.");
	}
}