package edu.uky.ai.sat;

import edu.uky.ai.logic.Proposition;

/**
 * Represents the three possible values that a {@link Variable} in a
 * satisfiability {@link Problem} can have: true, false, or unknown.
 * 
 * @author Stephen G. Ware
 */
public enum Value {
	
	/** A true value */
	TRUE,
	
	/** A false value */
	FALSE,
	
	/** A value that is not yet known */
	UNKNOWN;
	
	@Override
	public String toString() {
		if(this == TRUE)
			return Proposition.TRUE.toString();
		else if(this == FALSE)
			return Proposition.FALSE.toString();
		else
			return "?";
	}
	
	/**
	 * Returns the opposite of this value. True and false are opposites of one
	 * another. The opposite of unknown is unknown.
	 * 
	 * @return the opposite value
	 */
	public Value negate() {
		if(this == TRUE)
			return FALSE;
		else if(this == FALSE)
			return TRUE;
		else
			return UNKNOWN;
	}
}
