package edu.uky.ai.sat;

import edu.uky.ai.util.Utilities;

/**
 * The result of a {@link Solver}'s search for a satisfying assignment.
 * 
 * @author Stephen G. Ware
 */
public class Result {

	/** The solver that perform the search */
	public final Solver solver;
	
	/** The problem that was attempted */
	public final Problem problem;
	
	/** Whether or not a satisfying assignment was found */
	public final boolean success;
	
	/** The assignment as it was returned (which may or may not be satisfying) */
	public final Assignment solution;
	
	/** A brief description of why the search succeeded or failed */
	public final String reason;
	
	/** The number of operations performed by the search */
	public final int operations;
	
	/** The number of milliseconds that passed during the search */
	public final long time;
	
	Result(Solver solver, Problem problem, Assignment assignment, String reason, int operations, long time) {
		this.solver = solver;
		this.problem = problem;
		this.success = assignment.getValue() == Value.TRUE;
		this.solution = assignment;
		this.reason = reason;
		this.operations = operations;
		this.time = time;
	}
	
	@Override
	public String toString() {
		String str = "[" + solver.name + " ";
		if(success)
			str += "succeeded";
		else
			str += "failed";
		str += " on " + problem.name + "; ";
		str += operations + " operations; ";
		str += Utilities.time(time);
		if(reason != null)
			str += "; " + reason;
		return str + "]";
	}
}
