package edu.uky.ai.logic;

/**
 * A literal is an {@link Atom} or a {@link NegatedAtom negated atom}.
 * 
 * @author Stephen G. Ware
 */
public interface Literal extends Proposition {

	@Override
	public Literal substitute(Substitution substitution);
	
	@Override
	public Literal negate();
	
	@Override
	public default Literal toCNF() {
		return this;
	}

	@Override
	public default Literal toDNF() {
		return this;
	}
}
