package edu.uky.ai.logic;

import java.util.HashSet;
import java.util.Iterator;

/**
 * An implementation of {@link MutableState} that uses a
 * {@link java.util.HashMap} to keep track of which atoms are true.
 * 
 * @author Stephen G. Ware
 */
public class HashState implements MutableState {

	/** All currently true atoms */
	private final HashSet<Atom> atoms;
	
	/**
	 * Constructs a new state in which no atoms are true.
	 */
	public HashState() {
		this.atoms = new HashSet<>();
	}
	
	/**
	 * Constructs a new state which has exactly the same true atoms as a given
	 * {@link HashState}.
	 * 
	 * @param toClone the state to copy
	 */
	@SuppressWarnings("unchecked")
	public HashState(HashState toClone) {
		this.atoms = (HashSet<Atom>) toClone.atoms.clone();
	}
	
	/**
	 * Constructs a new state which has exactly the same true atoms as a given
	 * {@link State}.
	 * 
	 * @param toClone the state to copy
	 */
	public HashState(State toClone) {
		this();
		toClone.forEach(atom -> add(atom));
	}
	
	@Override
	public String toString() {
		String string = "";
		for(Atom atom : atoms)
			string += atom + " ";
		return string.trim();
	}
	
	@Override
	public HashState clone() {
		return new HashState(this);
	}
	
	@Override
	public Iterator<Atom> iterator() {
		return atoms.iterator();
	}
	
	@Override
	public boolean contains(Atom atom) {
		return atoms.contains(atom);
	}

	@Override
	public void add(Atom atom) {
		atoms.add(atom);
	}

	@Override
	public void remove(Atom atom) {
		atoms.remove(atom);
	}
}
