package edu.uky.ai.logic;

/**
 * A constant represents a specific unique thing.
 * 
 * @author Stephen G. Ware
 */
public class Constant extends Term {

	/**
	 * Constructs a constant with the given type and name.
	 * 
	 * @param type the type of the constant
	 * @param name the name of the constant
	 */
	public Constant(String type, String name) {
		super(type, name);
	}

	@Override
	public boolean isGround() {
		return true;
	}
	
	@Override
	public Constant substitute(Substitution substitution) {
		return this;
	}
}
