package edu.uky.ai.data;

import java.io.Serializable;

/**
 * An individual value; each {@link DataPoint} in a {@link DataSet} defines a
 * value for each {@link Feature}.
 * 
 * @author Stephen G. Ware
 */
public interface Value extends Serializable {

	/**
	 * Returns true if this value is one of the {@link Discrete}
	 * data types (i.e. {@link Nominal} or {@link Ordinal}), false otherwise.
	 * 
	 * @return true if this value is discrete
	 */
	public default boolean isDiscrete() {
		return this instanceof Discrete;
	}
	
	/**
	 * Returns true if this value is one of the {@link Numeric}
	 * data types (i.e. {@link Ordinal} or {@link Interval}), false otherwise.
	 * 
	 * @return true if this value is numeric
	 */
	public default boolean isNumeric() {
		return this instanceof Numeric;
	}
	
	/**
	 * Returns true if this value is the {@link Nominal} data type, false
	 * otherwise.
	 * 
	 * @return true if this value is nominal
	 */
	public default boolean isNominal() {
		return this instanceof Nominal;
	}
	
	/**
	 * Returns true if this value is the {@link Ordinal} data type, false
	 * otherwise.
	 * 
	 * @return true if this value is ordinal
	 */
	public default boolean isOrdinal() {
		return this instanceof Ordinal;
	}
	
	/**
	 * Returns true if this value is the {@link Interval} data type, false
	 * otherwise.
	 * 
	 * @return true if this value is interval
	 */
	public default boolean isInterval() {
		return this instanceof Interval;
	}
}