package edu.uky.ai.data;

import edu.uky.ai.Settings;

/**
 * Interval values can be represents as numbers where the distance between them
 * is proportionate to the difference between the values. They are
 * {@link Numeric}. Common examples of interval values are temperature,
 * distance, price, etc.
 * 
 * @author Stephen G. Ware
 */
public class Interval implements Numeric {
	
	/** Serial version UID */
	private static final long serialVersionUID = Settings.VERSION_UID;
	
	/** The number associated with this value */
	public final double number;
	
	/**
	 * Constructs a new interval value from a given number.
	 * 
	 * @param number the number
	 */
	public Interval(double number) {
		this.number = number;
	}
	
	@Override
	public boolean equals(Object other) {
		return getClass().equals(other.getClass()) && number == ((Interval) other).number;
	}
	
	@Override
	public int hashCode() {
		return Double.hashCode(number);
	}
	
	@Override
	public String toString() {
		return Double.toString(number);
	}

	@Override
	public double getNumber() {
		return number;
	}
}