package edu.uky.ai.data;

/**
 * A discrete value is one of a pre-defined set of possible symbols. Each
 * discrete value has a unique name which can be accessed via the
 * {@link #getName()} method. Discrete values include {@link Nominal} and
 * {@link Ordinal} data types.
 * 
 * @author Stephen G. Ware
 */
public interface Discrete extends Value {

	/**
	 * Returns the unique name of this value.
	 * 
	 * @return a string
	 */
	public String getName();
}