package edu.uky.ai.rl.dungeon;

import edu.uky.ai.rl.Transition;

/**
 * Represnets the results of transitioning from one state to another in a
 * {@link Dungeon}.
 * 
 * @author Stephen G. Ware
 */
public class DungeonTransition extends Transition {
	
	/** The new state */
	public final DungeonState state;
	
	/** A message to explain the result to the player */
	public final String message;

	/**
	 * Constructs a new transition object.
	 * 
	 * @param state the new state
	 * @param reward the reward earned for this transition
	 * @param message a message to explain the result to the player
	 */
	public DungeonTransition(DungeonState state, double reward, String message) {
		super(state, reward);
		this.state = state;
		this.message = message;
	}
	
	@Override
	public String toString() {
		return message;
	}
}
