package edu.uky.ai.rl.dungeon;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

import edu.uky.ai.rl.ProcessParser.Parser;

/**
 * A utility for paring {@link Dungeon} objects.
 * 
 * @author Stephen G. Ware
 */
public class DungeonParser implements Parser {

	@Override
	public Dungeon parse(String name, InputStream stream) throws IOException {
		try(ObjectInputStream in = new ObjectInputStream(stream)) {
			return new Dungeon(name, (Tile[][]) in.readObject());
		}
		catch(Exception ex) {
			throw new IOException("Dungeon file is not formatted correctly.", ex);
		}
	}
}
