package edu.uky.ai.rl.dungeon;

import java.io.Serializable;

import edu.uky.ai.rl.Action;
import edu.uky.ai.util.ImmutableArray;

/**
 * Represents the actions available to a dungeon exploration agent.
 * 
 * @author Stephen G. Ware
 */
public enum DungeonAction implements Serializable, Action {

	/** Moves up one tile */
	UP,
	
	/** Moves down one tile */
	DOWN,
	
	/** Moves right one tile */
	RIGHT,
	
	/** Moves left one tile */
	LEFT;
	
	static final ImmutableArray<Action> ALL = new ImmutableArray<>(new Action[] { UP, DOWN, RIGHT, LEFT });
}
