package edu.uky.ai.rl;

/**
 * An object returned by {@link StochasticProcess#transition(State, Action)}
 * which gives the new state of the process and the reward that resulted from
 * moving into that state.
 * 
 * @author Stephen G. Ware
 */
public class Transition {

	/** The new state to which the process has transitioned */
	public final State state;
	
	/** The reward (or punishment, if negative) for transitioning to the new state */
	public final double reward;
	
	/**
	 * Constructs a new transition object.
	 * 
	 * @param state the new state of the process
	 * @param reward the reward for transitioning to that state
	 */
	public Transition(State state, double reward) {
		this.state = state;
		this.reward = reward;
	}
}
