package edu.uky.ai.rl;

/**
 * Represents a single state that a {@link StochasticProcess} can be in.
 * 
 * @author Stephen G. Ware
 */
public interface State {

	/**
	 * Indicates whether or not this state is a terminal state (one past which)
	 * a stochastic process cannot transition).
	 * 
	 * @return true if the state is terminal, false otherwise
	 */
	public boolean isTerminal();
}
