package edu.uky.ai.rl;

import java.awt.BorderLayout;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

/**
 * Displays a GUI of a {@link StochasticProcess} during learning and
 * evaluation.
 * 
 * @author Stephen G. Ware
 */
public class ProcessFrame extends JFrame {
	
	private static final long serialVersionUID = edu.uky.ai.Settings.VERSION_UID;
	private final int delay;
	private final JLabel header = new JLabel();
	
	/**
	 * Constructs a new GUI. The GUI is initially empty and not visible until
	 * the first call to {@link #set(Learner, StochasticProcess, String)}.
	 * 
	 * @param delay the number of milliseconds to wait between frames when the
	 * process's state changes
	 */
	public ProcessFrame(int delay) {
		super("Reinforcement Learning");
		this.delay = delay;
		setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		try { UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()); }
		catch(Exception ignored){/* ignored*/}
		header.setFont(new Font("monospaced", Font.BOLD, 14));
		header.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
	}
	
	/**
	 * Changes the GUI (making it visible if it was not already) to display the
	 * given learner's name, the name of the task, the phase (usually either
	 * "Learning" or "Evaluation"), and a visual representation of the given
	 * process (via {@link StochasticProcess#getGUI(int)}).
	 * 
	 * @param learner the learner currently working on the given process
	 * @param process the process currently being worked on
	 * @param phase the name of the current phase (usually "Learning" or "Evaluation")
	 */
	public void set(Learner learner, StochasticProcess process, String phase) {
		getContentPane().removeAll();
		header.setText("Agent: " + learner + "   Task: " + process + "   Phase: " + phase);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(header, BorderLayout.NORTH);
		getContentPane().add(process.getGUI(delay), BorderLayout.CENTER);
		setResizable(true);
		pack();
		setResizable(false);
		if(!isVisible()) {
			setLocationRelativeTo(null);
			setVisible(true);
		}
		repaint();
	}
}
