package edu.uky.ai.rl;

import java.io.Serializable;

/**
 * A policy maps {@link State}s to {@link Action}s; in other words, for any
 * given {@link State} of a {@link StochasticProcess}, a policy decides which
 * {@link Action} is most likely to lead to the highest reward.
 * 
 * @author Stephen G. Ware
 */
public interface Policy extends Serializable {

	/**
	 * Given any {@link State} of a {@link StochasticProcess} this method
	 * should return the action which is most likely to lead to the maximum
	 * reward.
	 * 
	 * @param state the current state the reinforcement learner is in
	 * @return the action that is most likely to lead to the highest reward for the agent
	 */
	public Action choose(State state);
}
