package edu.uky.ai.rl;

import edu.uky.ai.SearchBudget;

/**
 * Used to enforce a specific search budget on a {@link StochasticProcess}. The
 * {@link #transition(State, Action)} and {@link #getGUI(int)} methods pass thru
 * to the underlying process around which this object wraps, but this object
 * has its own search budget. Clone made via the {@link #clone()} method use the
 * same search budget object as this object.
 * 
 * @author Stephen G. Ware
 */
final class BudgetWrapper extends StochasticProcess {
	
	/** The process around which this wrapper wraps */
	private final StochasticProcess process;

	/**
	 * Constructs a new search budget wrapper.
	 * 
	 * @param process the process around which to wrap
	 * @param budget the search budget to use
	 */
	public BudgetWrapper(StochasticProcess process, SearchBudget budget) {
		super(process.name, process.initial, process.actions, budget);
		this.process = process;
	}
	
	@Override
	public final BudgetWrapper clone() {
		return new BudgetWrapper(process.clone(), budget);
	}

	@Override
	public final Transition transition(State state, Action action) {
		budget.checkTime();
		budget.incrementOperations();
		return process.transition(state, action);
	}

	@Override
	public ProcessPanel getGUI(int delay) {
		return process.getGUI(delay);
	}
}
