package edu.uky.ai.chess.state;

/**
 * Represents the two players of a chess game: white and black.
 * 
 * @author Stephen G. Ware
 */
public enum Player {

	/** The white player */
	WHITE,
	
	/** The black player */
	BLACK;
	
	/**
	 * Returns the opposite player.
	 * 
	 * @return white if this object is black, black if this object is white
	 */
	public Player other() {
		if(this == WHITE)
			return BLACK;
		else
			return WHITE;
	}
}
