package edu.uky.ai.chess.gui;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

import edu.uky.ai.chess.Settings;

/**
 * An instance of {@link ChessDisplay} that shows the game in a
 * {@link javax.swing.JFrame JFrame}.
 * 
 * @author Stephen G. Ware
 */
public class ChessFrame extends ChessDisplay {

	/**
	 * Constructs a new chess GUI as a JFrame.
	 */
	ChessFrame() {
		super();
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
		catch(Exception ex) {
			// do nothing
		}
		JFrame frame = new JFrame(Settings.NAME);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(board, BorderLayout.CENTER);
		panel.add(banner, BorderLayout.NORTH);
		Container content = frame.getContentPane();
		content.setLayout(new BorderLayout());
		content.add(panel, BorderLayout.CENTER);
		content.add(console, BorderLayout.EAST);
		frame.setResizable(false);
		frame.pack();
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}
}
