package edu.uky.ai.chess;

/**
 * Keeps track of the overall performance of one agent againt another.
 * 
 * @author Stephen G. Ware
 */
class Result {

	public final Agent agent;
	public final Agent opponent;
	public double score = 0;
	public int moves = 0;
	public int states = 0;
	
	public Result(Agent agent, Agent opponent) {
		this.agent = agent;
		this.opponent = opponent;
	}
	
	public void add(Game game) {
		if(game.getWinner() == agent)
			score += 1;
		else if(game.getWinner() == null)
			score += 0.5;
		if(game.white == agent) {
			moves += game.getWhiteMoves();
			states += game.getWhiteStates();
		}
		else {
			moves += game.getBlackMoves();
			states += game.getBlackStates();
		}
	}
}
