package edu.uky.ai.chess.state;

import java.util.function.Predicate;

/**
 * Represents the rook chess piece.
 * 
 * @author Stephen G. Ware
 */
public class Rook extends Piece {

	/**
	 * Constructs a new rook for the given player at the given location.
	 * 
	 * @param player the player who controls the rook
	 * @param file the piece's file (column) on the board
	 * @param rank the piece's rank (row) on the board
	 */
	public Rook(Player player, int file, int rank) {
		super(player, file, rank);
	}
	
	@Override
	public String toString() {
		return "R";
	}

	@Override
	boolean anyMove(Board board, Predicate<Board> predicate) {
		return board.tryAllMoves(this, 0, 1, predicate) ||
				board.tryAllMoves(this, 1, 0, predicate) ||
				board.tryAllMoves(this, 0, -1, predicate) ||
				board.tryAllMoves(this, -1, 0, predicate);
	}

	@Override
	public Rook move(int dfile, int drank) {
		return new Rook(player, file + dfile, rank+ drank);
	}
}
