package edu.uky.ai.chess.state;

import java.util.function.Predicate;

/**
 * Represents the queen chess piece.
 * 
 * @author Stephen G. Ware
 */
public class Queen extends Piece {

	/**
	 * Constructs a new queen for the given player at the given location.
	 * 
	 * @param player the player who controls the queen
	 * @param file the piece's file (column) on the board
	 * @param rank the piece's rank (row) on the board
	 */
	public Queen(Player player, int file, int rank) {
		super(player, file, rank);
	}
	
	@Override
	public String toString() {
		return "Q";
	}

	@Override
	boolean anyMove(Board board, Predicate<Board> predicate) {
		return board.tryAllMoves(this, 0, 1, predicate) ||
				board.tryAllMoves(this, 1, 1, predicate) ||
				board.tryAllMoves(this, 1, 0, predicate) ||
				board.tryAllMoves(this, 1, -1, predicate) ||
				board.tryAllMoves(this, 0, -1, predicate) ||
				board.tryAllMoves(this, -1, -1, predicate) ||
				board.tryAllMoves(this, -1, 0, predicate) ||
				board.tryAllMoves(this, -1, 1, predicate);
	}

	@Override
	public Queen move(int dfile, int drank) {
		return new Queen(player, file + dfile, rank + drank);
	}
}
