package edu.uky.ai.chess.state;

import java.util.function.Predicate;

/**
 * Represents the bishop chess piece.
 * 
 * @author Stephen G. Ware
 */
public class Bishop extends Piece {

	/**
	 * Constructs a new bishop for the given player at the given location.
	 * 
	 * @param player the player who controls the bishop
	 * @param file the piece's file (column) on the board
	 * @param rank the piece's rank (row) on the board
	 */
	public Bishop(Player player, int file, int rank) {
		super(player, file, rank);
	}
	
	@Override
	public String toString() {
		return "B";
	}

	@Override
	boolean anyMove(Board board, Predicate<Board> predicate) {
		return board.tryAllMoves(this, 1, 1, predicate) ||
				board.tryAllMoves(this, 1, -1, predicate) ||
				board.tryAllMoves(this, -1, -1, predicate) ||
				board.tryAllMoves(this, -1, 1, predicate);
	}

	@Override
	public Bishop move(int dfile, int drank) {
		return new Bishop(player, file + dfile, rank + drank);
	}
}
