package edu.uky.ai.io;

/**
 * A list is a collection of 0 to many nodes.
 * 
 * @author Stephen G. Ware
 */
public class List extends Node {

	/** The number of elements in this list */
	public final int length;
	
	/** The first elerment in this list */
	public final Node first;
	
	/**
	 * Constructs a new list with a given first symbol and the first element
	 * and a given symbol as the first sibling of the first element.
	 * 
	 * @param first the first element in the list
	 * @param next the second element in the list
	 */
	List(Node first, Node next) {
		super(next);
		this.first = first;
		int l = 0;
		Node current = first;
		while(current != null) {
			l++;
			current = current.next;
		}
		this.length = l;
	}
	
	/**
	 * Returns the first element in the list or throws an exception if no such
	 * element exists.
	 * 
	 * @return the first element
	 * @throws FormatException if the list does not have a first element
	 */
	public Node requireFirst() {
		if(first == null)
			throw new FormatException("Expected non-empty list");
		else
			return first;
	}
	
	@Override
	public String toString() {
		String str = "(";
		Node current = first;
		boolean first = true;
		while(current != null) {
			if(first)
				first = false;
			else
				str += " ";
			str += current;
			current = current.next;
		}
		return str + ")";
	}
}
