package edu.uky.ai.chess.state;

import java.util.function.Predicate;

/**
 * Represents the knight chess piece.
 * 
 * @author Stephen G. Ware
 */
public class Knight extends Piece {

	/**
	 * Constructs a new knight for the given player at the given location.
	 * 
	 * @param player the player who controls the knight
	 * @param file the piece's file (column) on the board
	 * @param rank the piece's rank (row) on the board
	 */
	public Knight(Player player, int file, int rank) {
		super(player, file, rank);
	}
	
	@Override
	public String toString() {
		return "N";
	}

	@Override
	boolean anyMove(Board board, Predicate<Board> predicate) {
		return board.tryMove(this, 1, 2, predicate) ||
				board.tryMove(this, 2, 1, predicate) ||
				board.tryMove(this, 2, -1, predicate) ||
				board.tryMove(this, 1, -2, predicate) ||
				board.tryMove(this, -1, -2, predicate) ||
				board.tryMove(this, -2, -1, predicate) ||
				board.tryMove(this, -2, 1, predicate) ||
				board.tryMove(this, -1, 2, predicate);
	}

	@Override
	public Knight move(int dfile, int drank) {
		return new Knight(player, file+ dfile, rank + drank);
	}
}
