package edu.uky.ai.chess.state;

import java.util.function.Predicate;

/**
 * Represents the king chess piece.
 * 
 * @author Stephen G. Ware
 */
public class King extends Piece {

	/**
	 * Constructs a new king for the given player at the given location.
	 * 
	 * @param player the player who controls the king
	 * @param file the piece's file (column) on the board
	 * @param rank the piece's rank (row) on the board
	 */
	public King(Player player, int file, int rank) {
		super(player, file, rank);
	}
	
	@Override
	public String toString() {
		return "K";
	}

	@Override
	boolean anyMove(Board board, Predicate<Board> predicate) {
		if(board.tryMove(this, 0, 1, predicate) ||
				board.tryMove(this, 1, 1, predicate) ||
				board.tryMove(this, 1, 0, predicate) ||
				board.tryMove(this, 1, -1, predicate) ||
				board.tryMove(this, 0, -1, predicate) ||
				board.tryMove(this, -1, -1, predicate) ||
				board.tryMove(this, -1, 0, predicate) ||
				board.tryMove(this, -1, 1, predicate))
			return true;
		if(!board.hasMoved(this)) {
			Piece rook = board.getPieceAt(0, rank);
			if(rook != null &&
					rook.getClass() == Rook.class &&
					!board.hasMoved(rook) &&
					!board.pieceAt(1, rank) &&
					!board.pieceAt(2, rank) &&
					!board.pieceAt(3, rank) &&
					board.tryMove(this, -2, 0, predicate))
				return true;
			rook = board.getPieceAt(7, rank);
			if(rook != null &&
					rook.getClass() == Rook.class &&
					!board.hasMoved(rook) &&
					!board.pieceAt(5, rank) &&
					!board.pieceAt(6, rank) &&
					board.tryMove(this, 2, 0, predicate))
				return true;
		}
		return false;
	}

	@Override
	public King move(int dfile, int drank) {
		return new King(player, file+ dfile, rank + drank);
	}
}
