package edu.uky.ai.chess.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import edu.uky.ai.chess.Settings;

/**
 * A simple text console to display a transcript of the game.
 * 
 * @author Stephen G. Ware
 */
public class Console extends JPanel {
	
	/** Version UID */
	private static final long serialVersionUID = Settings.VERSION_UID;
	
	/** The width of the console in pixels */
	private static final int WIDTH = 400;
	
	/** The background color of the console */
	private static final Color TEXT_BACKGROUND = Color.WHITE;
	
	/** The color of the text in the console */
	private static final Color TEXT_FOREGROUND = Color.BLACK;
	
	/** The size of the text in the console */
	private static final int TEXT_SIZE = 16;
	
	/** The font to display console text in */
	private static final Font FONT = new Font(Font.MONOSPACED, Font.PLAIN, TEXT_SIZE);
	
	/** The swing control used to display the text */
	private final JTextArea textArea = new JTextArea();
	
	/** A scroll pane wrapped around the text */
	private final JScrollPane scroll;
	
	/**
	 * Constructs a new, empty console.
	 * 
	 * @param height the height of the console in pixels
	 */
	public Console(int height) {
		super(new BorderLayout());
		setBorder(BorderFactory.createEmptyBorder(TEXT_SIZE, TEXT_SIZE, TEXT_SIZE, TEXT_SIZE));
		textArea.setFont(FONT);
		textArea.setBackground(TEXT_BACKGROUND);
		textArea.setForeground(TEXT_FOREGROUND);
		textArea.setEditable(false);
		scroll = new JScrollPane(textArea);
		add(scroll, BorderLayout.CENTER);
		setPreferredSize(new Dimension(WIDTH, height));
	}
	
	/**
	 * Adds text to the transcript.
	 * 
	 * @param text the text to add
	 */
	public void append(String text) {
		textArea.append(text);
		textArea.setCaretPosition(textArea.getDocument().getLength());
		System.out.print(text);
	}
}
