package edu.uky.ai.chess.gui;

import java.awt.GraphicsEnvironment;

/**
 * A high-level container representing the game's current state, which can
 * displayed either on the console as text or on the screen as a GUI.
 * 
 * @author Stephen G. Ware
 */
public class ChessDisplay {

	/** The singleton instance of this class */
	private static ChessDisplay instance = null;
	
	/**
	 * Returns the singleton instance of of this class.
	 * 
	 * @return the frame
	 */
	public static final ChessDisplay getInstance() {
		if(instance == null) {
			if(GraphicsEnvironment.isHeadless())
				instance = new ChessDisplay();
			else
				instance = new ChessFrame();
		}
		return instance;
	}
	
	/** The board GUI */
	public final Board board;
	
	/** The text banner above the board */
	public final Banner banner;
	
	/** The text console that displayed the game transcript */
	public final Console console;
	
	/**
	 * Creates a new chess display object (with no GUI).
	 */
	ChessDisplay() {
		board = new Board();
		banner = new Banner();
		console = new Console(board.getHeight());
	}
}
