package edu.uky.ai.chess.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import edu.uky.ai.chess.Settings;

/**
 * A short text banner that appears above the chess board.
 * 
 * @author Stephen G. Ware
 */
public class Banner extends JPanel {

	/** Version UID */
	private static final long serialVersionUID = Settings.VERSION_UID;
	
	/** The background color of the text */
	private static final Color TEXT_BACKGROUND = Color.WHITE;
	
	/** The foreground color of the text */
	private static final Color TEXT_FOREGROUND = Color.BLACK;
	
	/** The size of the text */
	private static final int TEXT_SIZE = 30;
	
	/** The font the message should be displayed in */
	private static final Font FONT = new Font(Font.SERIF, Font.PLAIN, TEXT_SIZE);
	
	/** The swing label that displays the text */
	private final JLabel label = new JLabel("Chess", SwingConstants.CENTER);
	
	/**
	 * Constructs a new banner.
	 */
	public Banner() {
		super(new BorderLayout());
		setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		label.setFont(FONT);
		label.setBackground(TEXT_BACKGROUND);
		label.setForeground(TEXT_FOREGROUND);
		add(label, BorderLayout.CENTER);
	}
	
	/**
	 * Sets the current text of the banner.
	 * 
	 * @param text the banner's new message
	 */
	public void setText(String text) {
		label.setText(text);
	}
}
