package edu.uky.ai.chess;

import java.nio.ByteBuffer;

/**
 * Various settings that control the appearance and computational constraints
 * of the game.
 * 
 * @author Stephen G. Ware
 */
public class Settings {

	/** Name of the program */
	public static final String NAME = "Chess";
	
	/** The major version number */
	public static final int MAJOR_VERSION = 2;
	
	/** The minor version number */
	public static final int MINOR_VERSION = 0;
	
	/** A long that encapsulates both {@link #MAJOR_VERSION} and {@link #MINOR_VERSION} for use as version UID's */
	public static final long VERSION_UID = ByteBuffer.allocate(8).putInt(MAJOR_VERSION).putInt(MINOR_VERSION).getLong(0);
	
	/** The number of {@link edu.uky.ai.chess.state.State}s that can be generated during a single decision by a {@link edu.uky.ai.chess.Agent} */
	public static final int MOVE_LIMIT = 500000;
	
	/** The number of milliseconds that can pass while a {@link edu.uky.ai.chess.Agent} makes a single decision */
	public static final int TIME_LIMIT = 300000;
}
