package edu.uky.ai.util;

import java.util.Arrays;

/**
 * A tuple is simply an array of {@link Object}s implemented such that two
 * tuples are the same (i.e. {@link equals Object#equals(Object)}) if their
 * arrays contain values which are equal. Tuples can, for example, be use as
 * multi-valued keys to {@link java.util.HashMap}s.
 * 
 * @author Stephen G. Ware
 */
public class Tuple {

	/** The array of objects in the tuple */
	public final Object[] elements;
	
	/**
	 * Constructs a tuple from a given set of objects.
	 * 
	 * @param elements the objects
	 */
	public Tuple(Object...elements) {
		this.elements = elements;
	}
	
	/**
	 * Constructs a tuple of a given size with each element as null.
	 * 
	 * @param size the size of the tuple
	 */
	public Tuple(int size) {
		this(new Object[size]);
	}
	
	@Override
	public boolean equals(Object other) {
		return other instanceof Tuple && Arrays.equals(elements, ((Tuple) other).elements);
	}
	
	@Override
	public int hashCode() {
		return Arrays.hashCode(elements);
	}
	
	@Override
	public String toString() {
		return Arrays.toString(elements);
	}
}