package edu.uky.ai.rl.dungeon;

import java.io.Serializable;

import edu.uky.ai.Settings;
import edu.uky.ai.rl.State;
import edu.uky.ai.util.ImmutableArray;

public class DungeonState implements Serializable, State {

	private static final long serialVersionUID = Settings.VERSION_UID;
	public final int x;
	public final int y;
	public final ImmutableArray<Integer> tiles;
	public final boolean terminal;
	
	DungeonState(int x, int y, ImmutableArray<Integer> tiles, boolean terminal) {
		this.x = x;
		this.y = y;
		this.tiles = tiles;
		this.terminal = terminal;
	}
	
	@Override
	public boolean equals(Object other) {
		if(other instanceof DungeonState) {
			DungeonState otherState = (DungeonState) other;
			return x == otherState.x && y == otherState.y && tiles.equals(otherState.tiles) && terminal == otherState.terminal;
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return hash(hash(hash(Integer.hashCode(x), Integer.hashCode(y)), tiles), terminal);
	}
	
	private static final int hash(int hashCode, Object other) {
		return hashCode * 31 + other.hashCode();
	}
	
	@Override
	public String toString() {
		String string = "[x=" + x + ", y=" + y;
		for(int i=0; i<tiles.size(); i++)
			string += ", t" + i + "=" + tiles.get(i);
		return string + ", terminal=" + terminal + "]";
	}
	
	@Override
	public boolean isTerminal() {
		return terminal;
	}
	
	final DungeonState moveTo(int x, int y) {
		return new DungeonState(x, y, tiles, terminal);
	}
	
	final DungeonState set(int index, int value) {
		Integer[] array = new Integer[tiles.size()];
		for(int i=0; i<array.length; i++)
			array[i] = i == index ? value : tiles.get(i);
		return new DungeonState(x, y, new ImmutableArray<>(array), terminal);
	}
	
	final DungeonState terminal() {
		return new DungeonState(x, y, tiles, true);
	}
}
