package edu.uky.ai.rl;

/**
 * A collection of setting for reinforcement learning agents.
 * 
 * @author Stephen G. Ware
 */
public class Settings {

	/** The default number of milliseconds to wait between frames when updating the GUI */
	public static final int DEFAULT_GUI_DELAY = 5;
	
	/** The default number of times a reinforcement learning agent may call {@link StochasticProcess#transition(State, Action)} while learning a policy */
	public static final int DEFAULT_TRAINING_NODE_LIMIT = 100000;
	
	/** The default number of milliseconds a reinforcement learning agent may spend learning a policy */
	public static final long DEFAULT_TRAINING_TIME_LIMIT = 300000 * DEFAULT_GUI_DELAY;
	
	/** The default number of times a reinforcement learning agent may call {@link StochasticProcess#transition(State, Action)} while evaluating a policy */
	public static final int DEFAULT_EVALUATION_NODE_LIMIT = DEFAULT_TRAINING_NODE_LIMIT / 100;
	
	/** The default number of milliseconds a reinforcement learning agent may spend evaluating a policy */
	public static final long DEFAULT_EVALUATION_TIME_LIMIT = DEFAULT_TRAINING_TIME_LIMIT / 100;
}
