package edu.uky.ai.sl;

import java.io.Serializable;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.data.DataPoint;
import edu.uky.ai.data.Value;

/**
 * A model is a data structure or algorithm which attempts to classify unknown
 * {@link edu.uky.ai.data.DataPoint data points}. Models are generally learned
 * by finding trends in training data.
 * 
 * @author Stephen G. Ware
 */
@FunctionalInterface
public interface Model extends Serializable {

	/**
	 * Given an unknown {@link edu.uky.ai.data.DataPoint data point}, this
	 * method attempts to classify the point according to what was learned
	 * from the training data.
	 * 
	 * @param point the unknown data point to be classified
	 * @param budget the time limit allowed for classification
	 * @return a {@link edu.uky.ai.data.Value value} (class label) for the
	 * unknown data point
	 */
	public Value classify(DataPoint point, SearchBudget budget);
}