package edu.uky.ai.data;

import edu.uky.ai.Settings;

/**
 * Ordinal values have a meaningful order (i.e. they can be sorted). They can
 * be represented as integers, with smaller numbers coming before larger ones,
 * so they are {@link Discrete}, but the difference between the integers is not
 * necessarily meaningful (see {@link Interval}). A common example of ordinal
 * values are responses to Likert scale questions, \{Strongly Disagree,
 * Disagree, Neutral, Agree, Strongly Agree\}. They have a clear order, but the
 * distance between 'Neutral' and 'Agree' is not necessarily the same between
 * 'Agree' and 'Strongly Agree.'
 * 
 * @author Stephen G. Ware
 */
public class Ordinal implements Discrete, Numeric {
	
	/** Serial version UID */
	private static final long serialVersionUID = Settings.VERSION_UID;
	
	/** The value's name */
	public final String name;
	
	/** The value's rank in the ordered set of all possible values */
	public final int rank;
	
	/**
	 * Constructs an ordinal value with a given name and rank.
	 * 
	 * @param name the name
	 * @param rank the rank
	 */
	public Ordinal(String name, int rank) {
		this.name = name;
		this.rank = rank;
	}
	
	@Override
	public boolean equals(Object other) {
		return getClass().equals(other.getClass()) && name.equals(((Ordinal) other).name) && rank == ((Ordinal) other).rank;
	}
	
	@Override
	public int hashCode() {
		return rank;
	}
	
	@Override
	public String toString() {
		return getName();
	}
	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public double getNumber() {
		return rank;
	}
}