package edu.uky.ai.data;

import edu.uky.ai.Settings;

/**
 * Nominal values are defined as having one of a pre-defined, finite set of
 * names. They are {@link Discrete}, but values do not have any meaningful
 * order, so they are not {@link Ordinal}. Common examples of nominal values
 * include \{True, False\}, \{North, South, East, West\}, etc.
 * 
 * @author Stephen G. Ware
 */
public class Nominal implements Discrete {

	/** Serial version UID */
	private static final long serialVersionUID = Settings.VERSION_UID;
	
	/** The value's name */
	public String name;
	
	/**
	 * Constructs a new nominal value with the given name.
	 * 
	 * @param name the name
	 */
	public Nominal(String name) {
		this.name = name;
	}
	
	@Override
	public boolean equals(Object other) {
		return getClass().equals(other.getClass()) && name.equals(((Nominal) other).name);
	}
	
	@Override
	public int hashCode() {
		return getName().hashCode();
	}
	
	@Override
	public String toString() {
		return getName();
	}

	@Override
	public String getName() {
		return name;
	}
}